# Unity UI (uGUI)

Unity UI (uGUI) is a GameObject-based UI system that you can use to develop user interfaces for games and applications. It uses Components and the Game view to arrange, position, and style user interfaces.

| Topic | Description |
|:---|:---|
| [Canvas](UICanvas.md) | The Canvas is an area where you can place UI elements. |
| [Basic Layout](UIBasicLayout.md) | Position elements like text and images on a canvas. |
| [Visual Components](UIVisualComponents.md) | Learn how to add text and images to a canvas. |
| [Interaction Components](UIInteractionComponents.md) | Set up user interactions with elements on a canvas. |
| [Animation Integration](UIAnimationIntegration.md) | Animate elements like buttons when highlighted and clicked. |
| [Auto Layout](UIAutoLayout.md) | Change the size of layouts automatically. |
| [Rich Text](StyledText.md) | Use rich text in UI elements. |
| [Events](EventSystem.md) | The Event System sends events to objects in the application based on input. |
| [Reference](UIReference.md) | Comprehensive guide to understanding of uGUI features. |
| [UI How Tos](UIHowTos.md) | Solutions to common UI tasks. |

> [!NOTE]
> You can't use uGUI to create or change user interfaces of the Unity Editor.

## Additional Resources

- [Comparison of UI systems in Unity](https://docs.unity3d.com/6000.0/Documentation/Manual/UI-system-compare.html)
